/******************************************************************************
 *
 * Copyright (c) 2003-2004 PalmSource, Inc. All rights reserved.
 *
 * File: tgmath.h
 *
 * Release: Palm OS Developer Suite 5 SDK (68K) 4.0
 *
 * Description:
 *
 *
 *****************************************************************************/


#ifndef __PALMSOURCE_CC_HDR_TGMATH_H
#define __PALMSOURCE_CC_HDR_TGMATH_H

#include <math.h>
/* We do not support _Complex types */
/* #include <complex.h> */

#define acos(x)		__generic(x,,,	acos, acosf, acosl,	,,)(x)
#define asin(x)		__generic(x,,,	asin, asinf, asinl,	,,)(x)
#define atan(x)		__generic(x,,,	atan, atanf, atanl,	,,)(x)
#define acosh(x)	__generic(x,,,	acosh, acoshf, acoshl,	,,)(x)
#define asinh(x)	__generic(x,,,	asinh, asinhf, asinhl,	,,)(x)
#define atanh(x)	__generic(x,,,	atanh, atanhf, atanhl,	,,)(x)
#define cos(x)		__generic(x,,,	cos, cosf, cosl,	,,)(x)
#define sin(x)		__generic(x,,,	sin, sinf, sinl,	,,)(x)
#define tan(x)		__generic(x,,,	tan, tanf, tanl,	,,)(x)
#define cosh(x)		__generic(x,,,	cosh, coshf, coshl,	,,)(x)
#define sinh(x)		__generic(x,,,	sinh, sinhf, sinhl,	,,)(x)
#define tanh(x)		__generic(x,,,	tanh, tanhf, tanhl,	,,)(x)
#define exp(x)		__generic(x,,,	exp, expf, expl,	,,)(x)
#define log(x)		__generic(x,,,	log, logf, logl,	,,)(x)
#define pow(x,y)	__generic(x,y,,	pow, powf, powl,	,,)(x,y)
#define sqrt(x)		__generic(x,,,	sqrt, sqrtf, sqrtl,	,,)(x)
#define fabs(x)		__generic(x,,,	fabs, fabsf, fabsl,	,,)(x)

#define atan2(x,y)	__generic(x,y,,	atan2, atan2f, atan2l,	,,)(x,y)
#define cbrt(x)		__generic(x,,,	cbrt, cbrtf, cbrtl,	,,)(x)
#define ceil(x)		__generic(x,,,	ceil, ceilf, ceill,	,,)(x)
#define copysign(x,y)	__generic(x,y,,	copysign, copysignf, copysignl,	,,)(x,y)
#define erf(x)		__generic(x,,,	erf, erff, erfl,	,,)(x)
#define erfc(x)		__generic(x,,,	erfc, erfcf, erfcl,	,,)(x)
#define expm1(x)	__generic(x,,,	expm1, expm1f, expm1l,	,,)(x)
#define fdim(x,y)	__generic(x,y,,	fdim, fdimf, fdiml,	,,)(x,y)
#define floor(x)	__generic(x,,,	floor, floorf, floorl,	,,)(x)
#define fma(x,y,z)	__generic(x,y,z,fma, fmaf, fmal,	,,)(x,y,z)
#define fmax(x,y)	__generic(x,y,,	fmax, fmaxf, fmaxl,	,,)(x,y)
#define fmin(x,y)	__generic(x,y,,	fmin, fminf, fminl,	,,)(x,y)
#define fmod(x,y)	__generic(x,y,, fmod, fmodf, fmodl,	,,)(x,y)
#define frexp(x,y)	__generic(x,y,, frexp, frexpf, frexpl,	,,)(x,y)
#define hypot(x,y)	__generic(x,y,, hypot, hypotf, hypotl,	,,)(x,y)
#define ilogb(x)	__generic(x,,,	ilogb, ilogbf, ilogbl,	,,)(x)
#define ldexp(x,exp)	__generic(x,,,	ldexp, ldexpf, ldexpl,	,,)(x,exp)
#define lgamma(x)	__generic(x,,,	lgamma, lgammaf, lgamml,,,)(x)
#define llrint(x)	__generic(x,,,	llrint, llrintf, llrintl,,,)(x)
#define llround(x)	__generic(x,,,	llround, llroundf, llroundl,,,)(x)
#define log10(x)	__generic(x,,,	log10, log10f, log10l,	,,)(x)
#define log1p(x)	__generic(x,,,	log1p, log1pf, log1pl,	,,)(x)
#define log2(x)		__generic(x,,,	log2, log2f, log2l,	,,)(x)
#define logb(x)		__generic(x,,,	logb, logbf, logbl,	,,)(x)
#define lrint(x)	__generic(x,,,	lrint, lrintf, lrintl,	,,)(x)
#define lround(x)	__generic(x,,,	lround, lroundf, lroundl,,,)(x)
#define nearbyint(x)	__generic(x,,,	nearbyint,nearbyintf,nearbyinfl,,,)(x)
#define nextafter(x,y)	__generic(x,y,,	nextafter,nextafterf,nextafterl,,,)(x,y)
#define nexttoward(x,y) __generic(x,y,, nexttoward,nexttowardf,nexttowardl,,,)(x,y)
#define remainder(x,y)	__generic(x,y,, remainder,remainderf,remainderl,,,)(x,y)
#define remquo(x,y,quo)	__generic(x,y,, remquo,remquof,remquol,,,)(x,y,quo)
#define rint(x)		__generic(x,,,	rint,rintf,rintl,	,,)(x)
#define round(x)	__generic(x,,,	round,roundf,roundl,	,,)(x)
#define scalbn(x,n)	__generic(x,,,	scalbn,scalbnf,scalbnl,	,,)(x,n)
#define scalbln(x,n)	__generic(x,,,	scalbln,scalblnf,scalblnl,,,)(x,n)
#define tgamma(x)	__generic(x,,,	tgamma,tgammaf,tgammal,	,,)(x)
#define trunc(x)	__generic(x,,,	trunc,truncf,truncl,	,,)(x)

#endif /* __PALMSOURCE_CC_HDR_TGMATH_H */
